#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_KA_SP_J						122
#define KAZ_KA_SP_SL					256

#define KAZ_KA_SP_N						"29421818394147345935036136135391375994024126405325576672227398037493559452008116283594709069097880319117946343281357631447556041903884586208161678710597469727999746179863045388559147407457068275815914914983896392757878683919189075898269550939868181179868469970964809582599153788719655"
#define KAZ_KA_SP_LN					942 // in binary (118 bytes)

#define KAZ_KA_SP_g1					"65563"
#define KAZ_KA_SP_g2					"65617"

#define KAZ_KA_SP_Og1N					"99154693887499828557116081873795155652147461554242228686027806044656980768000"
#define KAZ_KA_SP_LOg1N					256 // in binary (33 bytes)
#define KAZ_KA_SP_Og2N					"297464081662499485671348245621385466956442384662726686058083418133970942304000"
#define KAZ_KA_SP_LOg2N					258 // in binary (33 bytes)

#define KAZ_KA_PUBLICKEY_BYTES			118 // in bytes for each e1, e2
#define KAZ_KA_PRIVATEKEY_BYTES			33 // in bytes for each a1, a2

#define KAZ_KA_SHAREDKEY_BYTES			118 // in bytes for shared key

extern void init_random();
extern void clear_random();
extern void KAZ_KA_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern int KAZ_KA_KEYGEN(unsigned char *kaz_ka_public_key, 
                         unsigned char *kaz_ka_private_key, 
                         const unsigned char *kaz_ka_types);

extern int KAZ_KEY_AGREEMENT(unsigned char *sharedkey, 
                             const unsigned char *kaz_ka_public_key_slave, 
                             const unsigned char *kaz_ka_private_key_primary);
#endif // FILE_H_INCLUDED
